/*Soubor tree.h pro skriptovaci jazyk SGS Stargate script

V tomto souboru definujeme vsechny struktury ktere tvori abstraktni syntaxni strom AST do ktereho je
kazdy skript rozlozen. AST - Abstract Syntax Tree, coz je vlastne vyjadreni zdrojoveho skriptu v cislech, ktere
jsou pro pocitac prijatelnejsi a srozumitelnejsi nez text
Rodicovskym uzlem je SCRIPT, ktery obsahuje ukazatel na TOPLEVEL. TOPLEVEL obsahuje ukazatele
na dalsi uzly typu TOPLEVEL. SCRIPT je tedy korenem AST stromu. TOPLEVEL predstavuje vetve a FUNCTION ktera je
soucasti kazdeho TOPLEVEL predstavuje listy. FUNCTION obsahuje DECLARATION - argumenty funkce a STATEMENT -telo funkce.
telo funkce se dale vetvi do vsech ostatnich struktur.
Dale jsou zde prototypy funkci ktere inicicializuji jednotlive struktury a prototypy funkci pro
vytvoreni spojoveho seznamu ze struktur CODE, ktere predstavuji jednotlive instrukce jazyka
*/

#ifndef tree_h
#define tree_h

#include <stdio.h>

/*definice typu jednotlivych struktur
Vetsina struktur muze predstavovat jednu z nekolika moznosti,
treba STATEMENT ktera predstavuje jeden prikaz muze predstavovat for,while, if,if-else atd.
To je udelano pomoci union, ktera v pameti rezervuje misto pro nejvetsi ze struktur a k jednotlivym
polozkam se pristupuju pomoci toho kterou polozku adresujeme. Proste v unii nemuzeme pouzivat vic nez jednu
polozku jako platnou
vetsina struktur obsahuje promennou kind ktera je jednoho z nasledujicich typu
*/
typedef enum TypeKInd {intT,doubleT,stringT,voidT} TypeKind;
typedef enum FunctionKind {localT,externT} FunctionKind;
typedef enum DeclarationKind {formalT,variableT,simplevarT} DeclarationKind;	//moznosti deklaraci
typedef enum SymbolKind {functionT,declarationT} SymbolKind;	//typy symbolu
typedef enum ForInitKind {declarationforinitT,expressionforinitT} ForInitKind;	//moznosti inicializace for cyklu
typedef enum StatementKind {skipT,expT,declstmT,returnT,ifT,ifelseT,whileT,forT,sequenceT,scopeT} StatementKind;	//typy vyrazu
typedef enum ExpressionKind {intconstT,stringconstT,doubleconstT,uminusT,notT,lvalueT,assignmentT,
			  equalsT,nequalsT,lessT,greaterT,lequalsT,gequalsT,plusT,minusT,mulT,divT,
			  modT,andT,orT,callT,plusassignT,minusassignT,mulassignT,divassignT,
			  modassignT, shlassignT, shrassignT, andassignT, orassignT, shlT, shrT,
			  postincT, prefincT, postdecT, prefdecT, bitorT, bitandT}	ExpressionKind;
typedef enum LValueKind {identifierT}	LValueKind;	//typy lvalue, tedy vyrazu na leve strane =, tedy jen identifikator
typedef enum InstructionKind {nopCK,mulCK,negCK,modCK,subCK,divCK,addCK,labelCK,lgotoCK,ifeqCK,	//vsechny instrukce jazyka
			  ifneCK,if_cmpeqCK,if_cmpgtCK,if_cmpltCK,if_cmpleCK,if_cmpgeCK,if_cmpneCK,
			  nreturnCK,loadCK,storeCK,ldc_intCK,ldc_stringCK,ldc_doubleCK,
			  dupCK,popCK,lcallCK,vreturnCK,shlCK,shrCK,incCK,decCK,ecallCK,andCK,orCK
			  }	CodeKind;
//****************************************************************************************************************
//Struktura predstavujici symbol
//****************************************************************************************************************
class SYMBOL
{
public:
	char*						name;
	SymbolKind					kind;				//typ symbolu

	union											//ukazatele na pozici v kodu kde je symbol definovan
	{
		struct FUNCTION*		functionS;			
		struct DECLARATION*		declarationS;
	} val;

public:
	bool						operator == (char* right)
	{
		return (strcmp(name,right) == 0) ? true : false;
	}
};
//****************************************************************************************************************
/*Koren stromu, v kompileru je jen jedna
ukazatel na toplevels muze byt prazdny, to je kdyz kompilujeme skript ktery obsahuje jen komentare
-sice skript na nic, ale muze byt
*/
//****************************************************************************************************************
struct SCRIPT
{
	int								line_number;	//cislo radku
	struct	TOPLEVEL*				toplevels;		//ukazatel na toplevel
	class   CHashedSymbolTable*		symbolTable;	//tabulka symbolu

	SCRIPT()	{toplevels = NULL;}
};
//****************************************************************************************************************
/*struktura predstavujici vetve stromu
pokud uz existuje, ukazatel na funkci musi byt vzdy platny
*/
//****************************************************************************************************************
struct TOPLEVEL
{
	int							line_number;
	FUNCTION*					function;	//ukazatel na funkci
	TOPLEVEL*					next;		//dalsi toplevel
};
//****************************************************************************************************************
/*struktura predstavujici funkci*/
//****************************************************************************************************************
struct FUNCTION
{
	FunctionKind					kind;
	int								line_number;

	/*co se tyka primo funkce*/
	struct TYPE*					type;
	char*							name;			//jmeno funkce
	char*							signature;		//sem se ulozi jmeno a podpis fce
	bool							returns_value;	//zjisti jestli fce vraci hodnotu
	struct DECLARATION*				declaration;	//argumenty funkce
	struct STATEMENT*				statements;		//telo funkce
	class  CHashedSymbolTable*		symbolTable;	//tabulka symbolu funkce
	int								localsLimit;	//
	int								labelCount;		//pocet navesti ve funkci
	struct LABEL*					labels;			//vsechna navesti vyskytujici se ve funkci
	class  CInstruction*			opcodes;		/*spojovy seznam struktur typu CODE predstavujicich
												  kod funkce v assembleru jazyka				*/

	char*							library;		//z jake knihovny fce je
};
//****************************************************************************************************************
//predstavuje datovy typ
//****************************************************************************************************************
struct TYPE
{
	int							line_number;	
	TypeKind					kind;	
};
//****************************************************************************************************************
/*predstavuje deklarovanou promennou*/
//****************************************************************************************************************
struct DECLARATION
{
	int							line_number;
	DeclarationKind				kind;			//typ deklarace
	//struct TYPE*				type;			//typ promenne

	union
	{
		struct
		{										//predstavuje deklaraci parametru funkce, tj treab (int a, in b)
			int offset;	/*resource*/			//kazda promenna musi mit definovany datovy typ a nemohou byt inicializovany
			char* name;							
		} formalD;														
		struct
		{
			//ModifierKind		modifier;		//deklarace promenne nebo vice promennych stejneho typu
			struct IDENTIFIER*	identifiers;	//promenne mohou byt inicializovany	
			struct EXPRESSION*	initialization;	//priklad: int a, b, c = 0;
			class  SYMBOL*		symbol;			//nebo bool c = true;
			int					offset;			//offset v zasobniku kde najdeme promennou
		} variableD;
		struct
		{
			char*				name;			//deklarace jedne promenne s inicilizaci, vyuziti
			struct EXPRESSION*	initialization;	//ve for cyklu, kde muyeme v inicilizaci deklarovat jednu
			int					offset;			//promennou a inicializovat ji
		} simplevarD;
	} val;

	DECLARATION*				next;			//dalsi deklarace
};
//****************************************************************************************************************
/*predstavuje inicilizaci czklu for*/
//****************************************************************************************************************
struct FORINIT
{
	int							line_number;
	ForInitKind					kind;

	union
	{
		struct DECLARATION*		declarationF;		//inicilizace muze byt bud deklarace nebo 
		struct EXPRESSION*		expressionF;		//vyraz
	} val;

	FORINIT*					next;
};
//****************************************************************************************************************
/*predstavuje jedn z prikazu ktery jazyk podporuje*/
//****************************************************************************************************************
struct STATEMENT
{
	int							line_number;
	StatementKind				kind;				//typ vyrazu

	union
	{
		struct EXPRESSION*		expression;			//vyraz
		struct DECLARATION*		declaration;		//deklarace promenne

		struct
		{											//return
			struct EXPRESSION*	expression;
		} returnS;									
		struct
		{											//if
			struct EXPRESSION*	condition;			//podminka
			struct STATEMENT*	body;				//telo
			int					stoplabel;			//cislo navesti - pro generaci kodu
		} ifS;										
		struct
		{
			struct EXPRESSION*	condition;			//podminka 	
			struct STATEMENT*	ifbody;				//telo casti po if
			struct STATEMENT*	elsebody;			//telo casti po else
			int					elselabel, stoplabel;	//
		} ifelseS;									//if-else
		struct
		{											//while
			struct EXPRESSION*	condition;			//podminka
			struct STATEMENT*	body;				//telo
			int					startlabel, stoplabel;	//cisla navesti-pro generaci kodu
		} whileS;
		struct
		{											//for
			struct FORINIT*		inits;				//inicilaizace
			struct EXPRESSION*	condition;			//podminka
			struct EXPRESSION*	updates;			//aktualizace	
			struct STATEMENT*	body;				//telo
			int					startlabel, stoplabel; //cisla navesti-pro generaci kodu
		} forS;
		struct
		{											//dekvence - stament1; statement2
			struct STATEMENT*	firts;				//prvni prikaz
			struct STATEMENT*	second;				//druhy prikaz
		} sequenceS;
		struct
		{											//dalsi blok kodu - {prikazy}
			class  CHashedSymbolTable*	symbolTable;		//tabulka symbolu bloku	
			struct STATEMENT*			statement;			//telo bloku
		} scopeS;
	} val;
};
//****************************************************************************************************************
/*identifikator*/
//****************************************************************************************************************
struct IDENTIFIER
{
	int							line_number;
	char*						name;				//jmeno identifikatoru - promenna nebo nazev funkce
	IDENTIFIER*					next;				//dalsi identifikator
};
//****************************************************************************************************************
//reprezentuje chybu v datovem typu
//****************************************************************************************************************
struct TYPE_ERROR
{
	bool						isError;	    //byla chyba?
	char*						msgError;		//zprava o chybe

	TYPE_ERROR()
	{
		isError = false;
		msgError = NULL;
	}
};
//****************************************************************************************************************
/*vyraz*/
//****************************************************************************************************************
struct EXPRESSION
{
	int							line_number;
	//struct TYPE*				type;
	ExpressionKind				kind;

	TYPE_ERROR					typeError;

	union
	{
		int						intconstE;			//integer konstanta
		char*					stringconstE;		//retezcova konstanta
		double					doubleconstE;		//double konstanta

		struct EXPRESSION*		uminusE;			//unarni minus
		struct LVALUE*			incE;				//prefixove nebo postfixove ++
		struct LVALUE*			decE;				//prefixove nebo postfixove --

		struct										//not
		{
			struct EXPRESSION*	expression;
			int					truelabel, stoplabel;
		} notE;

		struct LVALUE*			lvalue;

		struct										//prirazeni
		{
			struct LVALUE*		left;
			struct EXPRESSION*	right;
		} assignmentE;
		struct
		{
			struct LVALUE*		left;
			struct EXPRESSION*	right;
		} plusassignE;
		struct
		{
			struct	LVALUE*		left;
			struct  EXPRESSION*	right;
		} minusassignE;
		struct
		{
			struct	LVALUE*		left;
			struct  EXPRESSION*	right;
		} mulassignE;
		struct
		{
			struct	LVALUE*		left;
			struct  EXPRESSION*	right;
		} divassignE;
		struct
		{
			struct	LVALUE*		left;
			struct  EXPRESSION*	right;
		} modassignE;
		struct
		{
			struct	LVALUE*		left;
			struct  EXPRESSION*	right;
		} shlassignE;
		struct
		{
			struct	LVALUE*		left;
			struct  EXPRESSION*	right;
		} shrassignE;
		struct
		{
			struct	LVALUE*		left;
			struct  EXPRESSION*	right;
		} andassignE;
		struct
		{
			struct	LVALUE*		left;
			struct  EXPRESSION*	right;
		} orassignE;
		struct
		{
			struct	EXPRESSION*	left;
			struct  EXPRESSION* right;
		} shlE;
		struct
		{
			struct	EXPRESSION*	left;
			struct  EXPRESSION* right;
		} shrE;
		struct										//==
		{
			struct EXPRESSION*	left;
			struct EXPRESSION*	right;
			int					truelabel, stoplabel;
		} equalsE;
		struct										//!=
		{
			struct EXPRESSION*	left;
			struct EXPRESSION*	right;
			int					truelabel, stoplabel;
		} nequalsE;
		struct										//<
		{
			struct EXPRESSION*	left;
			struct EXPRESSION*	right;
			int					truelabel, stoplabel;
		} lessE;
		struct										//>
		{
			struct EXPRESSION*	left;
			struct EXPRESSION*	right;
			int					truelabel, stoplabel;
		} greaterE;
		struct										//<=
		{
			struct EXPRESSION*	left;
			struct EXPRESSION*	right;
			int					truelabel, stoplabel;
		} lequalsE;
		struct										//>=
		{
			struct EXPRESSION*	left;
			struct EXPRESSION*	right;
			int					truelabel, stoplabel;
		} gequalsE;
		struct										//+
		{
			struct EXPRESSION*	left;
			struct EXPRESSION*	right;
		} plusE;
		struct										//-
		{
			struct EXPRESSION*	left;
			struct EXPRESSION*	right;
		} minusE;
		struct										//*
		{
			struct EXPRESSION*	left;
			struct EXPRESSION*	right;
		} mulE;
		struct										// /
		{
			struct EXPRESSION*	left;
			struct EXPRESSION*	right;
		} divE;
		struct										//%
		{
			struct EXPRESSION*	left;
			struct EXPRESSION*	right;
		} modE;
		struct										//and
		{
			struct EXPRESSION*	left;
			struct EXPRESSION*	right;
			int					falselabel;
		} andE;
		struct										//or
		{
			struct EXPRESSION*	left;
			struct EXPRESSION*	right;
			int					truelabel;
		} orE;
		struct										//volani funkce
		{
			char*				name;
			struct EXPRESSION*	arguments;
			class  SYMBOL*		symbol;
		} callE;
		struct
		{
			EXPRESSION*			left;
			EXPRESSION*			right;
		} bitorE;
		struct
		{
			EXPRESSION*			left;
			EXPRESSION*			right;
		} bitandE;
	} val;

	EXPRESSION*					next;
};
//****************************************************************************************************************
/*vyraz na leve strane =*/
//****************************************************************************************************************
struct LVALUE
{
	int							line_number;
	class SYMBOL*				symbol;
	//ModifierKind				modifier;
	//struct TYPE*				type;
	LValueKind					kind;

	union
	{
		char*					idL;				//muze byt jen identifikator
	} val;
};
//****************************************************************************************************************
/*navesti v kodu*/
//****************************************************************************************************************
struct LABEL
{
	char*						name;
	class CInstruction*			position;
};

//****************************************************************************************************************
/*Prototypy funkci*/
//****************************************************************************************************************

SCRIPT*						makeSCRIPT(TOPLEVEL* toplevels);

TOPLEVEL*					makeTOPLEVELfunction(FUNCTION* function);

FUNCTION*					makeFUNCTION(char* name,DECLARATION* formals,STATEMENT* statements);
FUNCTION*					makeFUNCTIONextern(char* library,TYPE* type,char* name,int params);

TYPE*						makeTYPEvoid();
TYPE*						makeTYPEint();
TYPE*						makeTYPEstring();
TYPE*						makeTYPEdouble();

DECLARATION*				makeDECLARATIONformal(char* name);
DECLARATION*				makeDECLARATIONvariable(IDENTIFIER* identifiers,EXPRESSION* initialization);
DECLARATION*				makeDECLARATIONsimplevar(char* name,EXPRESSION* initialization);

FORINIT*					makeFORINITdeclaration(DECLARATION* declaration);
FORINIT*					makeFORINITexpression(EXPRESSION* expression);

STATEMENT*					makeSTATEMENTskip();
STATEMENT*					makeSTATEMENTdeclaration(DECLARATION* declaration);
STATEMENT*					makeSTATEMENTexpression(EXPRESSION* expression);
STATEMENT*					makeSTATEMENTreturn(EXPRESSION* expression);
STATEMENT*					makeSTATEMENTif(EXPRESSION* condition,STATEMENT* body);
STATEMENT*					makeSTATEMENTifelse(EXPRESSION* condition,STATEMENT* ifpart,STATEMENT* elsepart);
STATEMENT*					makeSTATEMENTwhile(EXPRESSION* condition,STATEMENT* body);
STATEMENT*					makeSTATEMENTfor(FORINIT* inits,EXPRESSION* condition,EXPRESSION* updates,STATEMENT* body);
STATEMENT*					makeSTATEMENTsequence(STATEMENT* first,STATEMENT* second);
STATEMENT*					makeSTATEMENTscope(STATEMENT* statement);

IDENTIFIER*					makeIDENTIFIER(char* name);

EXPRESSION*					makeEXPRESSIONintconst(int value);
EXPRESSION*					makeEXPRESSIONstringconst(char* value);
EXPRESSION*					makeEXPRESSIONdoubleconst(double value);
EXPRESSION*					makeEXPRESSIONuminus(EXPRESSION* expresion);
EXPRESSION*					makeEXPRESSIONnot(EXPRESSION* expression);
EXPRESSION*					makeEXPRESSIONlvalue(LVALUE* lvalue);
EXPRESSION*					makeEXPRESSIONassignment(LVALUE* lvalue,EXPRESSION* right);
//************
EXPRESSION*					makeEXPRESSIONplusassign(LVALUE* lvalue,EXPRESSION* right);
EXPRESSION*					makeEXPRESSIONminusassign(LVALUE* lvalue,EXPRESSION* right);
EXPRESSION*					makeEXPRESSIONmulassign(LVALUE* lvalue,EXPRESSION* right);
EXPRESSION*					makeEXPRESSIONdivassign(LVALUE* lvalue,EXPRESSION* right);
EXPRESSION*					makeEXPRESSIONmodassign(LVALUE* lvalue,EXPRESSION* right);
EXPRESSION*					makeEXPRESSIONshlassign(LVALUE*	lvalue,EXPRESSION* right);
EXPRESSION*					makeEXPRESSIONshrassign(LVALUE* lvalue,EXPRESSION* right);
EXPRESSION*					makeEXPRESSIONandassign(LVALUE* lvalue,EXPRESSION* right);
EXPRESSION*					makeEXPRESSIONorassign(LVALUE*	lvalue,EXPRESSION* right);
EXPRESSION*					makeEXPRESSIONshl(EXPRESSION* left,EXPRESSION* right);
EXPRESSION*					makeEXPRESSIONshr(EXPRESSION* left,EXPRESSION* right);
EXPRESSION*					makeEXPRESSIONpostinc(LVALUE* lvalue);
EXPRESSION*					makeEXPRESSIONprefinc(LVALUE* lvalue);
EXPRESSION*					makeEXPRESSIONpostdec(LVALUE* lvalue);
EXPRESSION*					makeEXPRESSIONprefdec(LVALUE* lvalue);
//*************
EXPRESSION*					makeEXPRESSIONequals(EXPRESSION* left,EXPRESSION* right);
EXPRESSION*					makeEXPRESSIONnequals(EXPRESSION* left,EXPRESSION* right);
EXPRESSION*					makeEXPRESSIONless(EXPRESSION* left,EXPRESSION* right);
EXPRESSION*					makeEXPRESSIONgreater(EXPRESSION* left,EXPRESSION* right);
EXPRESSION*					makeEXPRESSIONlequals(EXPRESSION* left,EXPRESSION* right);
EXPRESSION*					makeEXPRESSIONgequals(EXPRESSION* left,EXPRESSION* right);
EXPRESSION*					makeEXPRESSIONplus(EXPRESSION* left,EXPRESSION* right);
EXPRESSION*					makeEXPRESSIONminus(EXPRESSION* left,EXPRESSION* right);
EXPRESSION*					makeEXPRESSIONmul(EXPRESSION* left,EXPRESSION* right);
EXPRESSION*					makeEXPRESSIONdiv(EXPRESSION* left,EXPRESSION* right);
EXPRESSION*					makeEXPRESSIONmod(EXPRESSION* left,EXPRESSION* right);
EXPRESSION*					makeEXPRESSIONand(EXPRESSION* left,EXPRESSION* right);
EXPRESSION*					makeEXPRESSIONor(EXPRESSION* left,EXPRESSION* right);
EXPRESSION*					makeEXPRESSIONcall(char* name,EXPRESSION* arguments);
EXPRESSION*					makeEXPRESSIONbitand(EXPRESSION* left,EXPRESSION* right);
EXPRESSION*					makeEXPRESSIONbitor(EXPRESSION* left,EXPRESSION* right);

LVALUE*						makeLVALUEidentifier(char* identifier);

//****************************************************************************************************************
/*Trida predstavujici instrukc jazyka*/
//****************************************************************************************************************
class CInstruction
{
public:
	InstructionKind				kind;				//typ instrukce
	int							visited;
	union
	{
		int						labelC;
		int						gotoC;
		int						ifeqC;
		int						ifneC;
		int						if_cmpeqC;
		int						if_cmpgtC;
		int						if_cmpltC;
		int						if_cmpleC;
		int						if_cmpgeC;
		int						if_cmpneC;
		int						loadC;
		int						storeC;
		int						ldc_intC;
		bool					ldc_boolC;
		char*					ldc_stringC;
		double					ldc_doubleC;
		FUNCTION*				lcallC;
		struct
		{
			FUNCTION*			function;
			int					arguments;
		}						ecallC;
	} val;

	CInstruction*				next;
public:
	CInstruction*				nop(CInstruction* next);
	CInstruction*				mul(CInstruction* next);
	CInstruction*				neg(CInstruction* next);
	CInstruction*				mod(CInstruction* next);
	CInstruction*				sub(CInstruction* next);
	CInstruction*				div(CInstruction* next);
	CInstruction*				add(CInstruction* next);
	CInstruction*				label(int label, CInstruction* next);
	CInstruction*				lgoto(int label, CInstruction* next);
	CInstruction*				ifeq(int label, CInstruction* next);
	CInstruction*				ifne(int label, CInstruction* next);
	CInstruction*				if_cmpeq(int label, CInstruction* next);
	CInstruction*				if_cmpgt(int label, CInstruction* next);
	CInstruction*				if_cmplt(int label, CInstruction* next);
	CInstruction*				if_cmple(int label, CInstruction* next);
	CInstruction*				if_cmpge(int label, CInstruction* next);
	CInstruction*				if_cmpne(int label, CInstruction* next);
	CInstruction*				nreturn(CInstruction* next);
	CInstruction*				vreturn(CInstruction* next);
	CInstruction*				load(int arg, CInstruction* next);
	CInstruction*				store(int arg, CInstruction* next);
	CInstruction*				dup(CInstruction* next);
	CInstruction*				pop(CInstruction* next);
	CInstruction*				ldc_int(int arg, CInstruction* next);
	CInstruction*				ldc_string(char* arg, CInstruction* next);
	CInstruction*				ldc_double(double arg, CInstruction* next);
	CInstruction*				lcall(FUNCTION* arg,CInstruction* next);
	CInstruction*				ecall(FUNCTION* function,int args,CInstruction* next);

	CInstruction*				shl(CInstruction* next);
	CInstruction*				shr(CInstruction* next);
	CInstruction*				inc(CInstruction* next);
	CInstruction*				dec(CInstruction* next);

	CInstruction*				and(CInstruction* next);
	CInstruction*				or(CInstruction* next);
};


#endif